
PROCEDURE BUSACKER(
       N,S,T,INF,TARGETFLOW:INTEGER;
   VAR COST,CAPA,FLOW      :ARRNN;
   VAR TOTALCOST           :INTEGER);

   VAR MCOST                  :ARRNN;
       DIST,PRED              :ARRN;
       STPATH                 :BOOLEAN;
       I,J,CURRENTFLOW,DELTA,D:INTEGER;

   PROCEDURE PDM(
          N,S,T,INF:INTEGER;
      VAR A        :ARRNN;
      VAR STPATH   :BOOLEAN;
      VAR DIST,PRED:ARRN);

      VAR QUEUE                      :ARRN;
          U,V,HEAD,NEXT,TEMP,NEWLABEL:INTEGER;

   BEGIN
      FOR V:=1 TO N DO BEGIN
         DIST[V]:=INF;  PRED[V]:=-1;
         QUEUE[V]:=-1
      END;  { FOR V }
      DIST[S]:=0;  U:=S;
      HEAD:=S;  QUEUE[HEAD]:=INF;
      WHILE U <> INF DO BEGIN           { QUEUE IS EMPTY IF U = INF }
         NEXT:=QUEUE[U];  QUEUE[U]:=0;
         FOR V:=1 TO N DO
            IF A[U,V] <> INF THEN BEGIN
               NEWLABEL:=DIST[U]+A[U,V];
               IF DIST[V] > NEWLABEL THEN BEGIN
                  DIST[V]:=NEWLABEL;  PRED[V]:=U;
                  TEMP:=NEXT;
                  IF QUEUE[V] < 0 THEN BEGIN { V WAS NEVER IN QUEUE }
                     QUEUE[HEAD]:=V;
                     HEAD:=V;  QUEUE[HEAD]:=INF;
                     IF TEMP = INF THEN TEMP:=V;
                     NEXT:=TEMP
                  END  { IF QUEUE[V] < 0 }
                  ELSE IF QUEUE[V] = 0 THEN BEGIN
                          { V WAS IN QUEUE, BUT IS NOT IN QUEUE NOW }
                          QUEUE[V]:=TEMP;  NEXT:=V
                       END
                       ELSE NEXT:=TEMP              { V IS IN QUEUE }
               END  { IF DIST[V] > NEWLABEL }
            END;  { IF A[U,V] <> INF, FOR V }
         U:=NEXT
      END;  { WHILE U <> INF }
      IF PRED[T] = -1 THEN STPATH:=FALSE
   END;  { PDM }

BEGIN                                                   { MAIN BODY }
   FOR I:=1 TO N DO
      FOR J:=1 TO N DO BEGIN
         FLOW[I,J]:=0;  MCOST[I,J]:=COST[I,J]
      END;
   CURRENTFLOW:=0;  STPATH:=TRUE;             { INITIALIZATION OVER }
   WHILE (CURRENTFLOW < TARGETFLOW) AND STPATH DO BEGIN
      PDM(N,S,T,INF,MCOST,STPATH,DIST,PRED);
      IF STPATH THEN BEGIN
         DELTA:=INF;  I:=T;
         REPEAT  { UNTIL I = S }
            J:=I;  I:=PRED[J];
            IF CAPA[I,J] > 0 THEN BEGIN              { FORWARD EDGE }
               D:=CAPA[I,J]-FLOW[I,J];
               IF D < DELTA THEN DELTA:=D
            END
            ELSE                                    { BACKWARD EDGE }
            IF FLOW[J,I] < DELTA THEN DELTA:=FLOW[J,I]
         UNTIL I = S;
         IF CURRENTFLOW+DELTA > TARGETFLOW THEN
            DELTA:=TARGETFLOW-CURRENTFLOW;
         I:=T;
         REPEAT  { UNTIL I = S }
            J:=I;  I:=PRED[J];
            IF CAPA[I,J] > 0 THEN BEGIN              { FORWARD EDGE }
               FLOW[I,J]:=FLOW[I,J]+DELTA;
               IF FLOW[I,J] = CAPA[I,J] THEN MCOST[I,J]:=INF;
               MCOST[J,I]:=-COST[I,J]
            END
            ELSE BEGIN                              { BACKWARD EDGE }
               FLOW[J,I]:=FLOW[J,I]-DELTA;
               MCOST[J,I]:=COST[J,I];
               IF FLOW[J,I] = 0 THEN MCOST[I,J]:=COST[I,J]
            END
         UNTIL I = S;
         CURRENTFLOW:=CURRENTFLOW+DELTA
      END  { IF STPATH }
   END;  { WHILE (CURRENTFLOW < ... }
   TOTALCOST:=0;
   FOR I:=1 TO N DO
      FOR J:=1 TO N DO
         IF FLOW[I,J] > 0 THEN
            TOTALCOST:=TOTALCOST+COST[I,J]*FLOW[I,J]
END;  { BUSACKER }
